dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 270, 250, "assets/images/table/cruise", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 2, 185, 400, "assets/images/table/cruise_2", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 3, 365, 400, "assets/images/table/cruise", "assets/images/food/item_mark1", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 2;
numServers = 1;

maxCoupleHappiness = 200;

-- Group 1
guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestTissue = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);


-- Group 2


guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(5, 8, 20000);

-- Group 3

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 9, 40000);


-- Group 4

guest = LManager.GenGuest(uncle);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);



LManager:SetSeatingGroup(10, 10, 60000);


-- Group 5

guest = LManager.GenGuest(female02);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestTissue = 100;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 13, 86000);

-- Group 6

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + male02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 17, 110000);


LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("dogDelay", 70000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("speakerDelay", 90000); 
LManager:SetLevelSetting ("speakerChance", 100);


-- Set up the Level Settings
LManager:SetLevelNumber(3,3);
LManager:SetLevelScores(6000, 8800);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/Uptempo 1.ogg","assets/audio/music/uptempo_2.ogg");
LManager:SetBackgroundImage("assets/images/bg_cruise");
LManager:SetChairImage("assets/images/table/chair03");


-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );